#include <cvidef.h>

/*=================== Sorensen DCS/DLM Include File =========================*/
     
#ifndef __SNSGA_HEADER
#define __SNSGA_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

#define VI_INSTR_WARNING_OFFSET                           (0x3FFC0900L)
#define VI_INSTR_ERROR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define SNSGA_ERROR_SYNTAX                       (VI_INSTR_ERROR_OFFSET + 0xF0L)

/*****************************************************************************/
/* Define Status Byte and Service Request Register Bits                      */
/*****************************************************************************/
#define	SNSGA_SB_PROTEVENT	0x02
#define	SNSGA_SB_ERRORQUERY	0x04
#define	SNSGA_SB_MAV			0x10
#define	SNSGA_SB_STANDEVENT	0x20
#define	SNSGA_SB_SRQ			0x40

/*****************************************************************************/
/* Define Standard Event Register Bits                                       */
/*****************************************************************************/
#define	SNSGA_SE_OPC			0x01
#define	SNSGA_SE_ERRORQUERY	0x04
#define	SNSGA_SE_DEVICEERROR	0x08
#define	SNSGA_SE_RANGEERROR	0x10
#define	SNSGA_SE_SYNTAXERROR	0x20
#define	SNSGA_SE_PWRON		0X80

/*****************************************************************************/
/* Define Protection Event and Protection Condition Register Bits            */
/*****************************************************************************/
#define	SNSGA_PE_VOLTMODE	0x01
#define	SNSGA_PE_CURRMODE	0x02
#define	SNSGA_PE_HW			0x04
#define	SNSGA_PE_OVP			0x08
#define	SNSGA_PE_OTP			0x10
#define	SNSGA_PE_EXTSD		0x20
#define	SNSGA_PE_FOLD		0x40
#define	SNSGA_PE_PRGMERROR	0X80

/*****************************************************************************/
/* Define Foldback Modes                                                     */
/*****************************************************************************/
#define	SNSGA_FB_NORMAL		0x00
#define	SNSGA_FB_VOLTMODE	0x01
#define	SNSGA_FB_CURRMODE	0x02

/*****************************************************************************/
/* Maximum time a thread will wait to gain control of the session, in        */
/* milli-seconds.															 */
/* All functions have an exclusive lock by VI session, preventing other      */
/* threads accessing the same function.                                      */
/*****************************************************************************/
#define THREAD_LOCK_TIMEOUT 7000

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus CVIFUNC SNSGA_init                   (ViRsrc         resourceName,
                                               ViBoolean      IDQuery,
                                               ViBoolean      resetDevice,
                                               ViPSession     instrSession);
                              
ViStatus CVIFUNC SNSGA_GenerateDCVolt         (ViSession      instrSession,
                                               ViReal64       voltage);
                                        
ViStatus CVIFUNC SNSGA_GenerateDCCurr         (ViSession      instrSession,
                                               ViReal64       current);
                                        
ViStatus CVIFUNC SNSGA_GenerateDCVRamp        (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       time);
                                          
ViStatus CVIFUNC SNSGA_GenerateDCCRamp        (ViSession      instrSession,
                                               ViReal64       current,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGA_OutState               (ViSession      instrSession,
                                               ViBoolean      state);

ViStatus CVIFUNC SNSGA_MeasureDCVolt          (ViSession      instrSession,
                                               ViReal64       *voltage);
                                    
ViStatus CVIFUNC SNSGA_MeasureDCCurr          (ViSession      instrSession,
                                               ViReal64       *current);

ViStatus CVIFUNC SNSGA_ModeQuery              (ViSession      instrSession,
                                               ViInt16        *mode);

ViStatus CVIFUNC SNSGA_VoltMode               (ViSession      instrSession,
                                               ViBoolean      serviceRequest);

ViStatus CVIFUNC SNSGA_CurrMode               (ViSession      instrSession,
                                               ViBoolean      serviceRequest);

ViStatus CVIFUNC SNSGA_NormalMode             (ViSession      instrSession);


ViStatus CVIFUNC SNSGA_ConfigDCVolt           (ViSession      instrSession,
                                               ViReal64       voltage);
                                          
ViStatus CVIFUNC SNSGA_ConfigDCCurr           (ViSession      instrSession,
                                               ViReal64       current);

ViStatus CVIFUNC SNSGA_ConfigDCVRamp          (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       time);
                                          
ViStatus CVIFUNC SNSGA_ConfigDCCRamp          (ViSession      instrSession,
                                               ViReal64       current,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGA_ConfigOVP              (ViSession      instrSession,
                                               ViReal64       ovp);
                                      
ViStatus CVIFUNC SNSGA_ConfigSoftLimits       (ViSession      instruSession,
                                               ViReal64       voltage,
                                               ViReal64       current);

ViStatus CVIFUNC SNSGA_ConfigPowerOn          (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       ovp);

ViStatus CVIFUNC SNSGA_ConfigFoldback         (ViSession      instrSession,
                                               ViInt16        mode);

ViStatus CVIFUNC SNSGA_ConfigProtDelay        (ViSession      instrSession,
                                               ViReal64       delay);

ViStatus CVIFUNC SNSGA_ConfigVoltAve          (ViSession      instrSession,
                                               ViInt16        average);

ViStatus CVIFUNC SNSGA_ConfigCurrAve          (ViSession      instrSession,
                                               ViInt16        average);

//ViStatus CVIFUNC SNSGA_configTerm 			  (ViSession 	  instrSession,
//                                               ViInt16        termChar);

ViStatus CVIFUNC SNSGA_ConfigProtEventEnable  (ViSession      instrSession,
                                               unsigned char  protectionEventEnable);

ViStatus CVIFUNC SNSGA_ConfigStandEventEnable (ViSession      instrSession,
                                               unsigned char  standardEventEnable);

ViStatus CVIFUNC SNSGA_ConfigSerReqEnable     (ViSession      instrSession,
                                               unsigned char  serviceRequestEnable);

ViStatus CVIFUNC SNSGA_OutputVoltQuery        (ViSession      instrSession,
                                               ViReal64       *voltage);
                                          
ViStatus CVIFUNC SNSGA_OutputCurrQuery        (ViSession      instrSession,
                                               ViReal64       *current);
                                          
ViStatus CVIFUNC SNSGA_OutputOVPQuery         (ViSession      instrSession,
                                               ViReal64       *OVP);

ViStatus CVIFUNC SNSGA_OutStateQuery          (ViSession      instruSession,
                                               ViBoolean      *state);

ViStatus CVIFUNC SNSGA_SoftLimitsQuery        (ViSession      instrSession,
                                               ViReal64       *voltage,
                                               ViReal64       *current);

ViStatus CVIFUNC SNSGA_PowerOnQuery           (ViSession      instrSession,
                                               ViReal64       *voltage,
                                               ViReal64       *current,
                                               ViReal64       *OVP);

ViStatus CVIFUNC SNSGA_protDelayQuery         (ViSession      instrumentHandle,
                                               ViReal64       *delay);

ViStatus CVIFUNC SNSGA_measVoltAveQuery       (ViSession      instrSession,
                                               ViInt16        *average);

ViStatus CVIFUNC SNSGA_measCurrAveQuery       (ViSession      instrSession,
                                               ViInt16        *average);

                                       
ViStatus CVIFUNC SNSGA_SendSWTrigger          (ViSession      instrSession,
                                               ViInt16        triggerType);
                                          
ViStatus CVIFUNC SNSGA_AbortTrigger           (ViSession      instrSession);

ViStatus CVIFUNC SNSGA_StatusByteQuery        (ViSession      instrSession,
                                               unsigned char  *statusByte,
                                               ViChar _VI_FAR statusMessage[]);
                                          
ViStatus CVIFUNC SNSGA_StandEventQuery        (ViSession      instrSession,
                                               unsigned char  *standardEventStatusRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_StandEventEnableQuery  (ViSession      instrSession,
                                               unsigned char  *standardEventEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_ProtEventQuery         (ViSession      instrSession,
                                               unsigned char  *protEventReg,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_ProtEventEnableQuery   (ViSession      instrSession,
                                               unsigned char  *protEventEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_ProtCondQuery          (ViSession       instrSession,
                                               unsigned char  *protCondReg,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_ServiceReqEnableQuery  (ViSession      instrSession,
                                               unsigned char  *serviceReqEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGA_reset                  (ViSession      instrSession);

ViStatus CVIFUNC SNSGA_clear                  (ViSession      instrSession);

ViStatus CVIFUNC SNSGA_errorQuery             (ViSession      instrSession,
                                               ViPInt32       errorCode,
                                               ViChar _VI_FAR errorMessage[]);
                                    
ViStatus CVIFUNC SNSGA_errorMessage           (ViSession      instrSession,
                                               ViStatus       statusCode,
                                               ViChar _VI_FAR message[]);
                                      
ViStatus CVIFUNC SNSGA_revisionQuery          (ViSession      instrSession,
                                               ViChar _VI_FAR driverRev[],
                                               ViChar _VI_FAR instrRev[]);
                                          
ViStatus CVIFUNC SNSGA_idQuery                (ViSession      instrSession,
                                               ViChar _VI_FAR idBuffer[]);
                                 
ViStatus CVIFUNC SNSGA_ModelQuery             (ViSession      instrSession,
                                               ViReal64       *modelVolt,
                                               ViReal64       *modelCurr);

                                          
// Added TCP/IP commands 8-14-06 // RBF
ViStatus CVIFUNC SNSGA_ConfigIp               (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR ipSetAddress[]);

ViStatus CVIFUNC SNSGA_IpQuery                (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR ipGetAddress[]);
                                                  
ViStatus CVIFUNC SNSGA_ConfigMask             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR maskSetAddress[]);

ViStatus CVIFUNC SNSGA_MaskQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR maskGetAddress[]);
                                                  
ViStatus CVIFUNC SNSGA_ConfigGate             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR gateSetAddress[]);

ViStatus CVIFUNC SNSGA_GateQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR gateGetAddress[]);
                                                  
ViStatus CVIFUNC SNSGA_ConfigDNS              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR dnsSetAddress[]);

ViStatus CVIFUNC SNSGA_DNSQuery                (ViSession     instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR dnsGetAddress[]);
                                                  
ViStatus CVIFUNC SNSGA_ConfigPort             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt32        listenPort);

ViStatus CVIFUNC SNSGA_PortQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt32        *listenPort);
                                                  
ViStatus CVIFUNC SNSGA_ConfigTerm             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt32        terminator);

ViStatus CVIFUNC SNSGA_TermQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViInt32        *terminator);

ViStatus CVIFUNC SNSGA_ConfigSlaveBaud        (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64        slaveBaud);

ViStatus CVIFUNC SNSGA_SlaveBaudQuery         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       *slaveBaud);

ViStatus CVIFUNC SNSGA_ConfigHost             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR setHost[]);

ViStatus CVIFUNC SNSGA_HostQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR getHost[]);

ViStatus CVIFUNC SNSGA_ConfigDesc             (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR setDesc[]);

ViStatus CVIFUNC SNSGA_DescQuery              (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR getDesc[]);
                                                  
ViStatus CVIFUNC SNSGA_MACQuery               (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR getMAC[]);

ViStatus CVIFUNC SNSGA_ConfigAutoIP           (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      autoIPMode);

ViStatus CVIFUNC SNSGA_AutoIPQuery            (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *autoIPMode);

ViStatus CVIFUNC SNSGA_ConfigDHCPMode         (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      dhcpMode);

ViStatus CVIFUNC SNSGA_DHCPModeQuery          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *dhcpMode);
                                                  
ViStatus CVIFUNC SNSGA_ConfigLANLED          (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      lanLED);

ViStatus CVIFUNC SNSGA_LANLEDQuery            (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViBoolean      *lanLED);
                                                  
ViStatus CVIFUNC SNSGA_ConfigLastCalDate      (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       month,
                                                  ViReal64       day,
                                                  ViReal64       year);

ViStatus CVIFUNC SNSGA_LastCalDateQuery       (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR lastCalDate[]);  

ViStatus CVIFUNC SNSGA_ConfigNextCalDate      (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViReal64       month,
                                                  ViReal64       day,
                                                  ViReal64       year);

ViStatus CVIFUNC SNSGA_NextCalDateQuery       (ViSession      instrSession,
                                                  ViChar _VI_FAR channelName[],
                                                  ViChar _VI_FAR nextCalDate[]);  


ViStatus CVIFUNC SNSGA_close                  (ViSession      instrSession);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
